<?php

namespace App\Http\Controllers\Therapists;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TherapistEducation;
use App\Http\Requests\Therapists\TherapistEducations\CreateRequest;
use App\Http\Requests\Therapists\TherapistEducations\UpdateRequest;
use App\Http\Resources\Web\TherapistEducationsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistEducationsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist');
      // $this->middleware('permission:therapist_educations.index');
      // $this->middleware('permission:therapist_educations.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_educations.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_educations.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_educations.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_educations.import',['only' => ['import']])
      // $this->middleware('permission:therapist_educations.update|therapist_educations.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_educations =  $therapist->therapist_educations()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_educations =  $therapist_educations->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_educations =  $therapist_educations->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_educations = $therapist_educations->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_educations = $therapist_educations->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_educations = $therapist_educations->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_educations = $therapist_educations->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_educations = $therapist_educations->get();
        return $therapist_educations;
      }
      $totalTherapistEducations = $therapist_educations->count();
      $therapist_educations = $therapist_educations->paginate($req->perPage);
      $therapist_educations = TherapistEducationsResource::collection($therapist_educations)->response()->getData(true);

      return $therapist_educations;
    }
    $therapist_educations = TherapistEducationsResource::collection($therapist->therapist_educations()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_educations;
  }

  /********* FETCH ALL TherapistEducations ***********/
    public function index()
    {
        $therapist_educations =  $this->getter();
        $response = generateResponse($therapist_educations,count($therapist_educations['data']) > 0 ? true:false,'Therapist Educations Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistEducations FOR Search ***********/
   public function filter(Request $request){
     $therapist_educations = $this->getter($request);
     $response = generateResponse($therapist_educations,count($therapist_educations['data']) > 0 ? true:false,'Filter Therapist Educations Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistEducation ***********/
    public function store(CreateRequest $request)
    {
        $therapist = auth()->user()->therapist;
        try{
            DB::beginTransaction();
            $request->merge(['therapist_id'=>auth()->user()->id]);
            $data = $request->all();
            $data['image'] = uploadFile($request,'file','therapist_educations');
      $therapist_education = $therapist->therapist_educations()->create($data);
      $therapist_education = $therapist->therapist_educations()->withAll()->find($therapist_education->id);
      $therapist_education = new TherapistEducationsResource($therapist_education);
      DB::commit();
    }
      catch (\Exception $e) {
        dd($e->getMessage(),$e->getTrace());
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_education)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_education->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_education = $therapist->therapist_educations()->withAll()->find($therapist_education);
        if($therapist_education){
          $therapist_education = new TherapistEducationsResource($therapist_education);
          $response = generateResponse($therapist_education,true,'Therapist Education Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'Therapist Education Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistEducation ***********/
    public function update(UpdateRequest $request, TherapistEducation $therapist_education)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_education->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->file) {
            $data['image'] = uploadFile($request,'file','therapist_educations',$therapist_education->image);
        } else {
            $data['image'] = $therapist_education->image;
        }
        $therapist_education->update($data);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistEducation Status***********/
    public function updateStatus(Request $request,TherapistEducation $therapist_education){
        $therapist = auth()->user()->therapist;
        if($therapist_education->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_education->update([
          'is_active' => $therapist_education->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'Therapist Education Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE Therapist Education ***********/
    public function destroy(Request $request,TherapistEducation $therapist_education)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_education->therapist_id != $therapist->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_education->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_education->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistEducation ***********/
    public function destroyPermanently(Request $request,$therapist_education)
    {
        $therapist= auth()->user()->therapist;
        $therapist_education = $therapist->therapist_educations()->withTrashed()->find($therapist_education);
        if($therapist_education){
            if($therapist_education->therapist_id != $therapist->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_education->trashed()) {
            $therapist_education->forceDelete();
            $response = generateResponse(null,true,'TherapistE xperience Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'Therapist Education is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistEducation not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore Therapist Education ***********/
    public function restore(Request $request,$therapist_education)
    {
      $therapist= auth()->user()->therapist;
      $therapist_education = $therapist->therapist_educations()->withTrashed()->find($therapist_education);
          if ($therapist_education->trashed()) {
            $therapist_education->restore();
            $response = generateResponse(null,true,'Therapist Education Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'Therapist Education is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
